<?php

class CfExternalRoles
{
    /**
     * @var $cfSettings PDO
     */
    private $cfSettings;


    /**
     * CfExternalRoles constructor.
     * @param PDO $cfSettings
     */
    public function __construct(PDO $cfSettings)
    {
        $this->cfsettings = $cfSettings;
    }

    /**
     * @return array
     */
    public function getRoles()
    {
        return $this->cfsettings->query('SELECT * FROM external_roles_map')->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * @param $internal
     * @return array
     */
    public function getExternalRoleByInternal($internal)
    {
        $stmt = $this->cfsettings->prepare('SELECT * FROM external_roles_map WHERE internal_role = ?');
        $stmt->execute([$internal]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    /**
     * @param $external
     * @param $internal
     * @return bool
     */
    public function addRoleMap($external, $internal)
    {
      $params = [':externalRole' => $external, ':internalRole' => $internal];
      return $this->cfsettings->prepare("INSERT INTO external_roles_map (external_role, internal_role) VALUES(:externalRole, :internalRole)")->execute($params);
    }

    /**
     * @param $external
     * @param $internal
     * @return bool
     */
    public function editRoleMap($external, $internal)
    {
        $params = [':external_role' => $external, ':internal_role' => $internal];
        return $this->cfsettings->prepare("UPDATE external_roles_map SET external_role = :external_role WHERE internal_role = :internal_role")->execute($params);
    }

    /**
     * @param $internal
     * @return bool
     */
    public function deleteRoleMap($internal)
    {
        $params = [':internal_role' => $internal];
        return $this->cfsettings->prepare("DELETE FROM external_roles_map  WHERE internal_role = :internal_role")->execute($params);
    }
}