<?php


/**
 * Class CfdbPdo
 */
class CfdbPdo
{

    /**
     * @var null
     */
    private static $instance = null;
    /**
     * @var PDO
     */
    private $conn;

    /**
     * @var string
     */
    private $host = OAUTH_DATABASE_HOST;
    /**
     * @var string
     */
    private $user = OAUTH_DATABASE_USER;
    /**
     * @var string
     */
    private $pass = OAUTH_DATABASE_PASS;
    /**
     * @var string
     */
    private $name = CFDB_DATABASE_NAME;
    /**
     * @var int
     */
    private $port = OAUTH_DATABASE_PORT;

    /**
     * 23505 PostgreSQL error code means a unique_violation error
     * https://www.postgresql.org/docs/current/errcodes-appendix.html
     */
    const UNIQUE_VIOLATION_CODE = 23505;

    /**
     * DbConnection constructor.
     */
    private function __construct()
    {
        $this->conn = new PDO("pgsql:host={$this->host}; dbname={$this->name};port={$this->port}", $this->user, $this->pass);
        if ($this->name == "cfdb")
        {
            try
            {
                $this->conn->query('SELECT obtain_shared_schema_lock()');
                syslog(LOG_DEBUG, 'Obtained shared schema lock');
            }
            catch (Exception $e)
            {
                syslog(LOG_ERR, 'Unable to obtain shared schema lock: ' . $e);
            }
        }
    }

    /**
     * @return DbConnection|null
     */
    public static function getInstance()
    {
        if (!self::$instance) {
            self::$instance = new CfdbPdo();
        }

        return self::$instance;
    }

    /**
     * @return PDO
     */
    public function getConnection()
    {
        return $this->conn;
    }
}