<?php
abstract class CfBaseResource extends Resource
{

  public $oAuthServer = null;
  public $username = null;
  public $accessToken = null;

  function __construct($parameters)
  {
    parent::__construct($parameters);
  }

  function _checkBasicAuthencication()
  {
    $cfAuthService = new CFAuthService();
    if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW']) || !$user = $cfAuthService->auth($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']))
    {
      throw new ResponseException("Not authenticated", Response::UNAUTHORIZED);
    }
    $this->username = $user;
  }

  function _checkOauthAuthentication()
  {
    $this->oAuthServer = Utils::getOauthServer();
    $oAuth2Request = OAuth2\Request::createFromGlobals();

    if (!$this->oAuthServer->verifyResourceRequest($oAuth2Request))
    {
      $oAuthResponse = $this->oAuthServer->getResponse();
      $oAuthException = new OauthException();
      $oAuthException->oauthBody = $oAuthResponse->getResponseBody('json');
      $oAuthException->oauthCode = $oAuthResponse->getStatusCode();
      $oAuthException->oAuthHeaders = $oAuthResponse->getHttpHeaders();
      throw $oAuthException;
    }

    $token = $this->oAuthServer->getAccessTokenData($oAuth2Request);
    $this->username = $token['user_id'];
    $this->accessToken = $token['access_token'];
  }
  /**
   * This is replacement function for web server that does not have apache_request_headers() function defined such as nginx.
   * @return array array of headers
   */
  function _getallheaders()
  {
    $headers = array();


    foreach ($_SERVER as $name => $value)
    {
      if (substr($name, 0, 5) == 'HTTP_')
      {
        $name = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
        $headers[$name] = $value;
      }
      else if ($name == "CONTENT_TYPE")
      {
        $headers["Content-Type"] = $value;
      }
      else if ($name == "CONTENT_LENGTH")
      {
        $headers["Content-Length"] = $value;
      }
    }
    return $headers;
  }

  function _checkAuthentication()
  {
    $headers = function_exists('apache_request_headers') ? apache_request_headers() : $this->_getallheaders();


    $authorization = !empty($headers['Authorization']) ? $headers['Authorization'] : 'basic'; // default to basic

    $authenticationScheme = 'basic';

    if (strpos(strtolower($authorization) , 'bearer') === 0)
    {
      $authenticationScheme = 'oAuth2';
    }


    switch ($authenticationScheme)
    {
    case 'oAuth2':
      {
        $this->_checkOauthAuthentication();
        break;
      }
    default:
      $this->_checkBasicAuthencication();
    }
  }

  function accessRequired()
  {
    $this->_checkAuthentication();
  }
}

class CfProtectedResource extends CfBaseResource
{
  var $username = null;
  var $oAuthServer = null;

  function __construct($parameters)
  {
    parent::__construct($parameters);
    $this->accessRequired();
  }
}
