<?php

namespace FR\V1_0\Entities\RemoteHub;


use FR\Interfaces\RemoteHubInterface;
use FR\Interfaces\RemoteHubsCollectionInterface;

class RemoteHubsCollection implements RemoteHubsCollectionInterface
{
    private $remoteHubs = [];
    private $position = 0;

    public function rewind() {
        $this->position = 0;
    }

    public function current() {
        return $this->remoteHubs[$this->position];
    }

    public function key() {
        return $this->position;
    }

    public function next() {
        ++$this->position;
    }

    public function valid() {
        return isset($this->remoteHubs[$this->position]);
    }


    public function offsetExists($offset)
    {
        return isset($this->remoteHubs[$offset]);
    }

    public function offsetGet($offset)
    {
        return isset($this->remoteHubs[$offset]) ? $this->remoteHubs[$offset] : null;
    }

    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->remoteHubs[] = $value;
        } else {
            $this->remoteHubs[$offset] = $value;
        }
    }

    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    public function toArray()
    {
        $result = [];
        /**
         * @var $hub RemoteHubInterface
         */
        foreach ($this->remoteHubs as $hub) {
            $result['id-' . $hub->getId()] = $hub->toArray();
        }

        return $result;
    }

    public function jsonSerialize()
    {
        return $this->toArray();
    }

    public function addRemoteHub(RemoteHubInterface $hub)
    {
        $this->remoteHubs[] = $hub;
    }
}
