<?php

namespace FR\V1_0\Entities\Transports;

use FR\Interfaces\TransportInterface;
use FR\Traits\FromArray;

class BaseRsyncTransport implements TransportInterface
{
    private $mode;
    private $ssh_user;
    private $ssh_host;
    private $ssh_pubkey;
    private $ssh_fingerprint;

    use FromArray;

    /**
     * @return string
     */
    public function getSshUser()
    {
        return $this->ssh_user;
    }

    /**
     * @param string $sshUser
     */
    public function setSshUser($sshUser)
    {
        $this->ssh_user = $sshUser;
    }

    public function validate()
    {
        $errors = [];

        if (!isset($this->mode) || empty($this->mode)) {
            $errors[] = '`mode` is required argument';
        }

        if (!isset($this->ssh_user) || empty($this->ssh_user)) {
            $errors[] = '`ssh_user` is required argument';
        }

        if (!isset($this->ssh_host) || empty($this->ssh_host)) {
            $errors[] = '`ssh_host` is required argument';
        }

        if (sizeof($errors) > 0) {
            throw new \ResponseException(implode(PHP_EOL, $errors), \Response::BADREQUEST);
        }
    }

    public function jsonSerialize()
    {
        return $this->toArray();
    }

    public function toArray()
    {
        return [
            'mode' => $this->getMode(),
            'ssh_user' => $this->getSshUser(),
            'ssh_host' => $this->getSshHost(),
            'ssh_pubkey' => $this->getSshPubkey(),
            'ssh_fingerprint' => $this->getSshFingerprint()
        ];
    }

    /**
     * @return string
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * @param string $mode
     */
    public function setMode($mode)
    {
        $this->mode = $mode;
    }

    /**
     * @return string
     */
    public function getSshHost()
    {
        return $this->ssh_host;
    }

    /**
     * @param string $sshHost
     */
    public function setSshHost($sshHost)
    {
        $this->ssh_host = $sshHost;
    }

    /**
     * @return string
     */
    public function getSshPubkey()
    {
        return $this->ssh_pubkey;
    }

    /**
     * @param string $sshPubkey
     */
    public function setSshPubkey($sshPubkey)
    {
        $this->ssh_pubkey = $sshPubkey;
    }

    /**
     * @return string
     */
    public function getSshFingerprint()
    {
        return $this->ssh_fingerprint;
    }

    /**
     * @param string $sshFingerprint
     */
    public function setSshFingerprint($sshFingerprint)
    {
        $this->ssh_fingerprint = $sshFingerprint;
    }
}
