<?php

namespace FR\V1_0\Models;


use FR\Interfaces\ConfigFileModelInterface;

/**
 * Class ConfigFileModel
 * @package FR\V1_0\Models
 */
class ConfigFileModel implements ConfigFileModelInterface
{
    const DIRECTORY_PATH = '/opt/cfengine/federation/cfapache/';
    const FILE_NAME = 'federation-config.json';

    public function save(string $data)
    {
        if (!is_dir(self::DIRECTORY_PATH)) {
            throw new \Exception(self::DIRECTORY_PATH . ' directory does not exist');
        }

        if (!is_writable(self::DIRECTORY_PATH)) {
            throw new \Exception(self::DIRECTORY_PATH . ' directory should be writable');
        }

        file_put_contents(self::DIRECTORY_PATH . self::FILE_NAME, $data);
    }

    public function delete()
    {
        $file = self::DIRECTORY_PATH . self::FILE_NAME;
        if (file_exists($file)) {
            unlink($file);
        }
    }
}
