<?php
/**
 * @uri /file-changes/statistics
 */
class FileChangesStatistics extends CfProtectedResource
{
    /**
     * @param $request
     *
     * @return Response
     */
    function get($request)
    {

        $cfFileChanges = new CfFileChanges($this->username);
        $response = new Response($request);
        $response->code = Response::OK;
        $statistics = $cfFileChanges->getStatistics(Utils::queryParam('fromTime'), Utils::queryParam('toTime'));

        $response->body = json_encode($statistics);
        return $response;
    }

}

/**
 * @uri /file-changes/files
 */
class FileChangesList extends CfProtectedResource
{
    /**
     * @param $request
     *
     * @rbacName Get files list
     * @rbacGroup File changes API
     * @rbacAlias fileChanges.files
     * @rbacAllowedByDefault
     *
     * @return Response
     */
    function get($request)
    {
        $cfFileChanges = new CfFileChanges($this->username);
        $response = new Response($request);
        $response->code = Response::OK;
        $files = $cfFileChanges->getFiles(Utils::queryParam('query', ''), Utils::queryParam('limit', 10));

        $response->body = json_encode($files);
        return $response;
    }
}
