<?php

/**
 * @uri /settings
 */
class Settings extends CfProtectedResource
{

    /**
     * @param $request
     *
     * @rbacName View settings
     * @rbacGroup Settings
     * @rbacAlias settings.get
     * @rbacAllowedByDefault
     *
     * @return Response
     */
    function get($request)
    {
        $user = $this->username;

        $response = new Response($request);
        $settings = cfapi_settings_get($user);
        $settings = SettingsHelper::removeLdapPassword($settings);
        $response->body = $settings;
        $response->code = Response::OK;

        return $response;
    }

    /**
     * @param $request
     *
     * @rbacName Update settings
     * @rbacGroup Settings
     * @rbacAlias settings.update
     *
     * @return Response
     * @throws Exception
     */
    function post($request)
    {
        $user = $this->username;

        $response = new Response($request);
        if (cfapi_settings_post($user, $request->data)) {
            $response->code = Response::NOCONTENT;
        } else {
            $response->code = Response::INTERNALSERVERERROR;
        }

        return $response;
    }

    /**
     * @param $request
     *
     * @rbacName Update settings
     * @rbacGroup Settings
     * @rbacAlias settings.update
     *
     * @return Response
     * @throws Exception
     */
    function patch($request)
    {
        $user = $this->username;
        $settings = json_decode(cfapi_settings_get($user));
        $currentSettings = (array)$settings->data[0];// transform current settings to array
        $newSettings = (array)json_decode($request->data); // transform request data settings to array

        $settings = array_replace( $currentSettings, $newSettings );
        SettingsHelper::removeUnAllowedSettings( $settings );
        $data = json_encode( $settings ); //replace current settings with new


        $response = new Response($request);

        if (cfapi_settings_post($user, $data)) {
            $response->code = Response::NOCONTENT;
        } else {
            $response->code = Response::INTERNALSERVERERROR;
        }

        return $response;
    }


}