<div class="settingsPage">
    <div>
        <div class="pageTitle">
            <h1><span>User profile</span></h1>
        </div>
        <h3>Security</h3>

        <div>
            <b>Username:</b> <?= htmlspecialchars($this->session->userdata('username')) ?>
        </div>
        <div class="margin-top-small">
            <button data-toggle="modal" class="btn btn-secondary change_password" title="change password">Change
                password
            </button>
        </div>

        <hr/>
        <h3>Date & time</h3>
        <div class="pullTop">
            <?php
            if (($this->session->flashdata('message'))) {
                $flashMessage = $this->session->flashdata('message');
                $this->session->unset_userdata('message');
                $content = $flashMessage['content'];
                $content_class = $flashMessage['type'];
                ?>
            <?php if (!empty($content)) { ?>
                <div style="margin-top: 13px;">
                    <div class="alert <?= htmlspecialchars($content_class) ?>">
                        <button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>
                        <?php echo $content; ?>
                    </div>
                </div>
            <?php }
                }
            ?>
        </div>

        <?php
        $this->load->helper('form_helper');
        $this->load->library(array('form_validation'));
        $attributes = array('class' => 'form-horizontal confirm-before-leave', 'id' => 'profile', 'autocomplete' => "off");
        echo form_open('settings/profile', $attributes);
        ?>


        <fieldset class="border-bottom">
            <div class="control-group">
                <label class="control-label" for="host">Display time zone</label>
                <div class="controls">
                    <select id="time_zone" name="time_zone">
                        <?php
                        foreach ($timeZonesList as $name => $tzs) {
                            echo "<optgroup label='$name'>";
                            foreach ($tzs as $tz) {
                                echo "<option " . ($profile['time_zone'] == $tz['value'] ? 'selected' : '') . " value='{$tz['value']}'>";
                                echo $tz['label'];
                                echo "</option>";
                            }
                            echo "</optgroup>";
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label" for="neveAskAgain">
                    Prompt when time zone changes
                </label>
                <div class="controls">
                    <label>
                        <?= form_checkbox(
                            [
                                'name' => 'neverAskAgain',
                                'id' => 'neverAskAgain',
                                'value' => '0',
                                'checked' => $neverAskAgain == 0
                            ]
                        ); ?>
                    </label>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label" for="useBrowserTime">
                    Automatically update time zone
                </label>
                <div class="controls">
                        <?= form_checkbox(
                            [
                                'name' => 'useBrowserTime',
                                'id' => 'useBrowserTime',
                                'value' => '1',
                                'checked' => $useBrowserTime == 1
                            ]
                        ); ?>
                </div>
            </div>
        </fieldset>
        <?php echo form_submit(array(
            'name' => 'submit',
            'class' => 'btn apply-button btn-primary btn-large pull-right',
            'value' => 'Apply'
        )); ?>

        <?php echo form_close(); ?>
        <script>
            $('#time_zone').chosen();
            $('input[name="submit"]').click(() => timezone.removeTimeZoneFromStorage());

            $('#useBrowserTime').change((e) => {
                if (e.target.checked == true) {
                    $('#neverAskAgain').attr('checked', false);
                }
            });
            $('#neverAskAgain').change((e) => {
                if (e.target.checked == true) {
                    $('#useBrowserTime').attr('checked', false);
                }
            });

            $('.change_password').click(function() {
                var userModalBody = {
                    'header':'<h2>Change password</h2>',
                    'body_url': MP_SITE_URL + '/auth/password_form',
                    'onEscape': function(){}
                };

                var mainDialog =    bootbox.dialog('', [], userModalBody);
                mainDialog.find('.modal-body').addClass('form-buttons');
            });
        </script>
    </div>
</div>
