<h3 class="inventoryfilter_title">Edit filter</h3>
<div class="inventoryfilter_main">
    <i ng-if="includeClasses" class="inventoryfilter_subtitle">You can filter hosts using rules for both classes and inventory attributes.</i>
    <div ng-repeat="filter in filters track by $index" ng-init="place = $index">
        <div ng-switch on="filter.type">
            <table ng-switch-default class="filters table no-border no-hover advancedReportFormTable">
                <tbody ng-form="filterType" class="control-group"
                       ng-class="{error:filterType.$dirty && (filterType.$invalid || filterType.$error.required)}">
                <tr class="no-hover">
                    <td>
                        <?php $this->load->view('directives/inventoryfilter_dropdown_new') ?>
                    </td>
                    <td>
                        <div ng-switch on="filter.type" class="filter-condition">
                            <div ng-switch-default class="input {{field.type}}" style="width:150px;">
                                <a class="btn dropdown-toggle disabled">
                                    <span>Select condition</span>
                                    <i class="bi bi-chevron-down"></i>
                                </a>
                            </div>

                            <div ng-init="filter.condition = (filter.condition | setDefaultConditionOption:'matches')"
                                 ng-switch-when="string">
                                <div class="btn-group filterTree">
                                    <a ng-class="{'disabled': readonly}" href="javascript:void(0)"
                                       data-toggle="dropdown" class="btn dropdown-toggle">
                                        <span ng-repeat="f in STRING_CONDITION | getLabelByValue:filter.condition | limitTo: 1">{{f.label}}</span>
                                        <i class="bi bi-chevron-down"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown_reports">
                                        <li ng-repeat="f in STRING_CONDITION"
                                            onmousemove="common.showTooltip(event, this.getAttribute('tooltip'))"
                                            tooltip="{{f.tooltip}}"
                                            onmouseleave="common.hideTooltip();"
                                        >
                                            <a href="javascript:void(0)"
                                               ng-click="
                                                   filter.condition = f.value;
                                                   updateFilterState();
                                                   regexValidation(filterType.string, filter)"
                                            >
                                                {{f.label}}
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div ng-init="filter.condition = (filter.condition | setDefaultConditionOption:'=')"
                                 ng-switch-when="int">
                                <div class="btn-group filterTree">
                                    <a ng-class="{'disabled': readonly}" href="javascript:void(0)"
                                       data-toggle="dropdown" class="btn dropdown-toggle">
                                        <span ng-repeat="f in NUMERIC_CONDITION | getLabelByValue:filter.condition | limitTo: 1">{{f.label}}</span>
                                        <i class="bi bi-chevron-down"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown_reports">
                                        <li ng-repeat="f in NUMERIC_CONDITION">
                                            <a href="javascript:void(0)"
                                               ng-click="filter.condition = f.value; updateFilterState();">{{f.label}}</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div ng-switch-when="real">
                                <div class="btn-group filterTree">
                                    <a ng-init="filter.condition = (filter.condition | setDefaultConditionOption:'=')"
                                       ng-class="{'disabled': readonly}" href="javascript:void(0)"
                                       data-toggle="dropdown" class="btn dropdown-toggle">
                                        <span ng-repeat="f in NUMERIC_CONDITION | getLabelByValue:filter.condition | limitTo: 1">{{f.label}}</span>
                                        <i class="bi bi-chevron-down"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown_reports">
                                        <li ng-repeat="f in NUMERIC_CONDITION">
                                            <a href="javascript:void(0)"
                                               ng-click="filter.condition = f.value; updateFilterState();">{{f.label}}</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div ng-switch-when="slist">
                                <div class="btn-group filterTree">

                                    <a ng-init="filter.condition = (filter.condition | setDefaultConditionOption:'matches')"
                                       ng-class="{'disabled': readonly}" href="javascript:void(0)"
                                       data-toggle="dropdown" class="btn dropdown-toggle">
                                        <span ng-repeat="f in LIST_CONDITION | getLabelByValue:filter.condition | limitTo: 1">{{f.label}}</span>
                                        <i class="bi bi-chevron-down"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown_reports">
                                        <li ng-repeat="f in LIST_CONDITION"
                                            onmousemove="common.showTooltip(event, this.getAttribute('tooltip'))"
                                            tooltip="{{f.tooltip}}"
                                            onmouseleave="common.hideTooltip();"
                                        >
                                            <a href="javascript:void(0)"
                                               ng-click="filter.condition = f.value; updateFilterState();">{{f.label}}</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div ng-switch-when="date">
                                <div class="btn-group filterTree">
                                    <a ng-init="filter.condition = (filter.condition | setDefaultConditionOption:'<')"
                                       ng-class="{'disabled': readonly}" href="javascript:void(0)"
                                       data-toggle="dropdown" class="btn dropdown-toggle">
                                        <span ng-repeat="f in DATE_CONDITION | getLabelByValue:filter.condition | limitTo: 1">{{f.label}}</span>
                                        <i class="bi bi-chevron-down"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown_reports">
                                        <li ng-repeat="f in DATE_CONDITION">
                                            <a href="javascript:void(0)"
                                               ng-click="filter.condition = f.value; updateFilterState();">{{f.label}}</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div ng-switch-when="context">
                                <div class="btn-group filterTree">
                                    <a ng-init="filter.condition = (filter.condition | setDefaultConditionOption:'ILIKE')"
                                       ng-class="{'disabled': readonly}" href="javascript:void(0)"
                                       data-toggle="dropdown" class="btn dropdown-toggle">
                                        <span ng-repeat="f in CONTEXT_CONDITION | getLabelByValue:filter.condition | limitTo: 1">{{f.label}}</span>
                                        <i class="bi bi-chevron-down"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown_reports">
                                        <li ng-repeat="f in CONTEXT_CONDITION">
                                            <a href="javascript:void(0)"
                                               ng-click="filter.condition = f.value; updateFilterState();">{{f.label}}</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                            <div ng-switch-when="class">

                            </div>
                        </div>
                    </td>

                    <td style="position: relative"
                        ng-hide="filter.condition == 'is_not_reported' || filter.condition == 'is_reported'">
                        <div ng-switch on="filter.type">
                            <div ng-switch-when='' class="input {{field.type}}" ng-class="field.required && 'required'">
                                Please specify field type:
                            </div>
                            <input ng-switch-default type="text" readonly placeholder="Enter value">
                            <input ng-switch-when="string"
                                   type="text"
                                   autocomplete="off"
                                   ng-readonly="readonly"
                                   ng-required="!filter.condition.includes('reported')"
                                   name="string"
                                   ng-model="filter.value"
                                   ng-bind-attr="{required:'{{field.required}}'}"
                                   filter="filter"
                                   validator="regexValidation(form, filter)"
                                   placeholder="Enter text"
                                   ng-blur="updateFilterState()"
                                   inventory-filter-validator
                            >
                            <span class="inventory_help" style="display: none;"></span>

                            <input ng-switch-when="int" type="number" ng-readonly="readonly"
                                   ng-required="!filter.condition.includes('reported')" name="int"
                                   ng-model="filter.value" ng-bind-attr="{required:'{{field.required}}'}"
                                   placeholder="Enter number" ng-blur="updateFilterState()">

                            <input ng-switch-when="real" type="number" step="any" ng-readonly="readonly"
                                   ng-required="!filter.condition.includes('reported')" name="real"
                                   ng-model="filter.value" ng-bind-attr="{required:'{{field.required}}'}"
                                   placeholder="Enter number" ng-blur="updateFilterState()">

                            <input ng-switch-when="slist" type="text" ng-readonly="readonly"
                                   ng-required="!filter.condition.includes('reported')" name="slist"
                                   ng-model="filter.value" ng-bind-attr="{required:'{{field.required}}'}"
                                   placeholder="Enter comma separated text" class="microcopy-search"
                                   ng-blur="updateFilterState()">

                            <input ng-switch-when="date"
                                   placeholder="Enter date"
                                   show-weeks=false
                                   ng-change="updateFilterState()"
                                   type="text"
                                   class="form-control"
                                   datepicker-popup="{{format}}"
                                   month-format="MM"
                                   ng-model="filter.value"
                                   is-open="openedDate[$index]"
                                   datepicker-options="dateOptions"
                                   date-disabled="disabled(date, mode)"
                                   close-text="Close"
                                   ng-blur="updateFilterState()"
                                   ng-readonly="readonly"
                                   ng-required="!filter.condition.includes('reported')"
                                   name="date"
                            />

                            <input ng-switch-when="context" type="text" ng-readonly="readonly"
                                   ng-required="!filter.condition.includes('reported')" name="context"
                                   ng-model="filter.value" ng-bind-attr="{required:'{{field.required}}'}"
                                   placeholder="Enter text" ng-blur="updateFilterState()">

                            <div class="definedCondition" ng-switch-when="class">
                                is defined
                            </div>

                        </div>
                    </td>
                    <td ng-show="((!filter.readonly) || (filter.readonly != 1)) && filter.type !== 'class'">
                        <span ng-show="filter.type&&!readonly"><a class="change-data-type" ng-click="filter.type=''"
                                                                  href="javascript:void(0)"><i
                                        class="bi bi-pencil-square"></i> Change data type</a></span>
                        <select ng-show="filter.type == ''" data-ng-model="filter.type"
                                ng-options="f.value as f.label for f in FIELD_TYPES"
                                data-ng-change="updateFilterState({{filter}})" class="pull-left"></select>
                    </td>

                    <td>
                        <span ng-hide="readonly" ng-click="removeFilter($index)" class="trackerDelete"><i
                                    class="bi bi-x dnc"></i></span>
                    </td>
                </tr>
                <tr class="inventory-valid no-hover" ng-switch on="filter.type">
                    <td>
                        <div ng-switch-when="int">
                            <span ng-show="filterType.$dirty && filterType.int.$invalid"
                                  class="help-block error margin-top-small">Value must be a number.</span>
                        </div>
                        <div ng-switch-when="string">
                            <span ng-show="filterType.string.$error.regex"
                                  value="{{filterType.string.$viewValue}}"></span>
                        </div>
                        <div ng-switch-when="real">
                            <span ng-show="filterType.$dirty && filterType.real.$invalid"
                                  class="help-block error margin-top-small">Value must be a number.</span>
                        </div>
                        <div ng-switch-default ng-hide="filter.optional">
                            <span ng-show="filterType.$dirty && filterType.$error.required"
                                  class="help-block error margin-top-small">Field cannot be empty.</span>
                        </div>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div>
        <btn href="javascript:void(0)" class="btn btn-link_noline" ng-click="filters.push({})">
            <i class="bi bi-plus-lg"></i> Add rule
        </btn>
    </div>
</div>

<div ng-hide="showfilterapplybtn || !filters.length" ng-class="{error:$parent.alertEdit.$dirty && (!filters.length)}">

    <input name="hasFilter" type="hidden" ng-model="filters[0]" required>

    <span class="help-block error"
          ng-show="$parent.inventoryAttrs.hasFilter.$invalid || $parent.inventoryAttrs.hasFilter.$error.required">You must choose at least one attribute to filter.</span>
</div>
