/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint plusplus: true */
/*global dashboardApp, angular, $*/

'use strict';

dashboardApp.factory('notKeptWidgetHelper',
    ['$q', 'notKeptWidgetService', '$window', '$location',
        function ($q, notKeptWidgetService, $window, $location) {
            let helper = {};
            let selectedDateRange = {};
            let todayDate = new Date();
            helper.goToNotKeptNotRepairedReport = function () {
                sessionStorage.clear();
                var url = MP_SITE_URL + "/advancedreports/goNotKeptReport";
                $window.location.href = url;
            }

            helper.chartConfig = {
                chart: {
                    type: 'line',
                    backgroundColor: 'transparent',
                    events: {
                        click: function (e) {
                            helper.goToNotKeptNotRepairedReport()
                        }
                    }
                },
                colors: [widgetColors.mainColor()],
                exporting: {
                    enabled: false
                },
                plotOptions: {
                    line: {
                        allowPointSelect: false,
                        cursor: 'pointer',
                        point: {
                            events: {
                                click: function () {
                                    helper.goToNotKeptNotRepairedReport();
                                }
                            }
                        }
                    }
                },
                tooltip: {
                    formatter: function () {
                        return 'Count: ' + this.y;
                    }
                },
                legend: {
                    enabled: false
                },
                series: [{
                    data: []
                }],
                title: {
                    text: ''
                },
                subtitle: {
                    text: ''
                },
                xAxis: {
                    categories: [],
                    title: {
                        text: null
                    },
                    allowDecimals: false
                },
                yAxis: {
                    allowDecimals: false,
                    min: 0,
                    title: {
                        text: 'Not kept count'
                    }
                },
                credits: {
                    enabled: false
                },
                loading: false
            };
            helper.getChartConfig = function () {
                return {...helper.chartConfig, colors: [widgetColors.mainColor()]}
            }
            helper.getNotKeptStats = function () {
                selectedDateRange = {
                    from: moment(this._returnDate(6)).format("YYYY-MM-DD 00:00:00"),
                    to: moment(todayDate).format("YYYY-MM-DD 23:59:59")
                }
                var promise = notKeptWidgetService.getNotKeptNotRepairedStats({
                    'from': selectedDateRange.from,
                    'to': selectedDateRange.to,
                }).then(
                    function (result) {
                        return result;
                    }
                );

                return promise
            };

            helper.convertArray = function (arr) {
                var returnData = {};
                returnData.array = [];
                returnData.axis = [];

                angular.forEach(arr, function (value, key) {
                    returnData.axis.push(value.date);
                    returnData.array.push(value.count);
                });
                return returnData;
            };

            helper.setChartData = function (stats) {
                var convertedData = helper.convertArray(stats);
                helper.chartConfig.series[0] = {
                    data: convertedData.array
                };
                helper.chartConfig.xAxis.categories = convertedData.axis;
            };

            helper._returnDate = function (days, startOfDay) {
                var date = new Date(new Date().setDate(todayDate.getDate() - days));

                if (startOfDay === true) {
                    date.setHours(0, 0, 0, 0);
                }
                return date;
            };

            return helper;
        }]);
