$(function () {
    const hostSearchUrl = MP_SITE_URL + '/host/searchHost';
    const hostPageUrl = MP_SITE_URL + '/hosts/';

    $('#global-host-search-input')
        .autocomplete({
        minLength: 3,
        autoFocus: true,
        source: function (request, response) {
            $.ajax({
                type: 'get',
                url: hostSearchUrl,
                dataType: 'json',
                data: {query: request.term},
                cache: false,
                success: function (data) {
                    var patternForIP = /^[0-9.]+$/;
                    if (data.length > 0) {
                        var result = $.map(data, function (value, key) {
                            return {
                                label: patternForIP.test(request.term) ? value.ipaddress : value.hostname,
                                value: value.hostkey
                            }
                        });
                        response(result);
                    } else {
                        response([{
                            label: 'No results found.',
                            value: false
                        }]);
                    }
                }
            })
        },
        focus: function (event, ui) {
            event.preventDefault();
        },
        select: function (event, ui) {
            var hostKey = ui.item.value;
            event.preventDefault();
            if (hostKey !== false) {
                window.location.replace(hostPageUrl + hostKey);
            }
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        ul.attr("id", "searchWrapper");
        const re = new RegExp(this.term) ;
        const t = item.label.replace(re, `<bold>${this.term}</bold>`);
        return $( "<li></li>" )
            .data( "item.autocomplete", item )
            .append( "<div>" + t + "</div>" )
            .appendTo( ul );
    };
});