<?php

/*
 * Full results from alert
 *
 */

?>
<div class="contentWrapper">
    <div class="pageTitle">

        <h1>
            <span ng-show="alertData.name">Status for alert '{{alertData.name}}'</span>
            <span ng-show="!alertData.name">Status for alert</span>

            <div class="btn-group no-btn pull-right">
                <a data-toggle="dropdown" class="btn no-btn dropdown-toggle option-menu right">
                 </a>
                <ul class="dropdown-menu pull-right">
                    <li ng-show="currentUser===alertData.username"><a ng-href="/dashboard/alerts/edit/{{alertData.id}}">Edit alert</a></li>
                    <li ng-show="currentUser===alertData.username"><a ng-click="removeAlertFromWidget(alertData.widgetid, alertData.id, alertData.name)">Remove alert</a></li>
                    <li ng-show="alertData.paused!=1 && currentUser===alertData.username" class="dropdown-submenu pull-left">
                        <a ng-click="">Pause alert</a>
                        <ul class="dropdown-menu">
                             <li ng-repeat="(itemId, item) in DCA.Pause_dropDown">
                                 <a ng-click="pauseAlert(alertData,item.value); $event.stopPropagation();">{{item.label}}</a>
                             </li>
                        </ul>
                    </li>
                    <li ng-show="alertData.paused && currentUser===alertData.username">
                        <a ng-click="resumeAlert(alertData); $event.stopPropagation();" href="javascript:void(0)">Resume alert</a>
                    </li>
                    <li><a ng-href="/dashboard/alerts/listAll">View all alerts</a></li>
                    <li><a ng-href="/dashboard/eventlog">View full event log</a></li>
                </ul>
            </div>
         </h1>
    </div>

    <div class="row-fluid float-left">
        <div class="span8">

            <?php $this->load->view('/partials/_notification'); ?>

            <div ng-show="alertData.paused!=1">

                <div ng-show="alertHostsData.totalHosts-length">
                    <h3 class="margin-bottom inline-block">Alert triggered on {{alertHostsData.totalHosts}} host<span ng-hide="alertHostsData.totalHosts===1">s</span></h3>

                    <table ng-show="ruleData.type=='policy'" class="table table-horizontal" id="hostTable">
                        <thead>
                            <th>Host name</th>
                            <th class="right">Promises triggering</th>
                        </thead>
                        <tbody>
                            <tr ng-repeat="host in alertHostsData.hosts">
                                <td>
                                     <a href="<?= site_url('hosts') ?>/{{host.hostkey}}">{{host.hostname}}</a>
                                </td>
                                <td class="right">
                                    <a href="<?php echo site_url('advancedreports/external'); ?>/sql/{{host.link_sql}}/includes/{{host.link_includes}}">{{host.triggered}}</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>


                    <table ng-show="ruleData.type=='softwareupdate'" class="table table-horizontal" id="hostTable">
                        <thead>
                            <th>Host name</th>
                            <th class="right">Updates triggering</th>
                        </thead>
                        <tbody>
                            <tr ng-repeat="host in alertHostsData.hosts">
                                <td>
                                    <a href="<?= site_url('hosts') ?>/{{host.hostkey}}">{{host.hostname}}</a>
                                </td>
                                <td class="right">
                                    <a href="<?php echo site_url('advancedreports/external'); ?>/sql/{{host.link_sql}}/includes/{{host.link_includes}}">{{host.triggered}}</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>

                    <table ng-show="ruleData.type=='inventory'" class="table table-horizontal" id="hostTable">
                        <thead>
                            <th class="sort-head"
                                ng-repeat="item in alertHostsData.hosts.header track by $index">{{item.columnName}}</th>
                            <th ng-hide="alertHostsData.hosts.header.length<2"></th>
                        </thead>
                        <tbody>
                            <tr ng-repeat="row in alertHostsData.hosts.rows">
                                <td  ng-repeat="item in row track by $index">
                                    <span ng-if="$index!=0">{{item}}</span>
                                    <a ng-if="$index==0" href="<?php echo site_url('assets/host_assets_by_name/'); ?>/{{row[0]}}">{{row[0]}}</a>
                                </td>
                                <td ng-hide="row.length<2"></td>
                            </tr>
                        </tbody>
                    </table>

                    <table ng-show="ruleData.type=='custom'" class="table table-horizontal" id="customHostTable">
                        <thead>
                        <th class="sort-head"
                            ng-repeat="item in alertHostsData.hosts.header track by $index"
                            ng-hide="$index==getHostKeyIndex()">{{item.columnName}}</th>
                        <th ng-hide="alertHostsData.hosts.header.length<2"></th>
                        </thead>
                        <tbody>
                        <tr ng-repeat="row in alertHostsData.hosts.rows">
                            <td  ng-repeat="item in row track by $index" ng-hide="$index==getHostKeyIndex()">
                                <span ng-if="$index!=0">{{item}}</span>
                                <a ng-if="$index==0" href="{{getHostLink(row)}}">{{getHostName(row)}}</a>
                            </td>
                        </tr>
                        </tbody>
                    </table>

                    <table ng-show="ruleData.type=='fileChanged'" class="table table-horizontal" id="fileChangedHostTable">
                        <thead>
                        <th class="sort-head"
                            ng-repeat="item in alertHostsData.hosts.header track by $index"
                            ng-hide="$index==getHostKeyIndex()">{{item.columnName}}</th>
                        <th ng-hide="alertHostsData.hosts.header.length<2"></th>
                        </thead>
                        <tbody>
                        <tr ng-repeat="row in alertHostsData.hosts.rows">
                            <td  ng-repeat="item in row track by $index" ng-hide="$index==getHostKeyIndex()">
                                <span ng-if="$index!=0">{{item}}</span>
                                <a ng-if="$index==0" href="{{getHostLink(row)}}">{{getHostName(row)}}</a>
                            </td>
                        </tr>
                        </tbody>
                    </table>

                    <p class="help-block no-margin pull-right">Showing {{Math.min(loadLimit.hosts,alertHostsData.totalHosts)}} of {{alertHostsData.totalHosts}} hosts</p>
                    <a class="pull-left" ng-show="alertHostsData.totalHosts-loadLimit.hosts>0" ng-click="loadNext('hosts')">Show next {{Math.min(10, alertHostsData.totalHosts-loadLimit.hosts)}} hosts</a>


                    <div class="buttons margin-top float-left">

                        <div class="pull-right" ng-show="alertHostsData.totalHosts-length">

                            <a class="btn btn-large" ng-show="ruleData.type=='policy'||ruleData.type=='softwareupdate'" href="<?php echo site_url('advancedreports/external'); ?>/sql/{{alertHostsData.links.all_flat_report}}">View report</a>

                            <a class="btn btn-large" ng-show="ruleData.type=='inventory'" href="<?php echo site_url('reports/inventory/alert'); ?>/{{alertData.id}}">View report</a>

                        </div>

                        <a ng-show="ruleData.type == 'policy' || ruleData.type == 'softwareupdate'" class="btn btn-large" href="<?php echo site_url('advancedreports/external'); ?>/sql/{{alertHostsData.links.all_summary_report}}">View <span ng-hide="alertHostsData.totalHosts==='1'">all</span> {{alertHostsData.totalHosts}} host<span ng-hide="alertHostsData.totalHosts==='1'">s</span></a>

                    </div>

                </div>

                <div ng-show="alertHostsData.totalHosts<1" class="muted margin-bottom-small">This alert has not been triggered on any hosts</div>
            </div>

            <div ng-show="alertData.paused==1" class="alert alert-warning">
                This alert is currently paused. <a ng-click="resumeAlert(alertData)">Resume alert</a>
            </div>

        </div>
        <div class="span4">
            <div class="margin-bottom">
                <h3>Alert details</h3>
                <div class="row-fluid">
                    <ul class="unstyled alert-details">
                        <li>
                            <b class="inline span4">Condition:</b>
                            <span class="span8">{{ruleData.name}}</span>
                        </li>
                        <li ng-show="ruleData.description">
                            <b class="inline span4">Description:</b>
                            <span class="span8 upper-first">{{ruleData.description}}</span>
                        </li>
                        <li>
                            <b class="inline span4">Type:</b>
                            <span class="span8 upper-first">{{ruleData.type}}</span>
                        </li>

                        <li ng-switch on="ruleData.type">
                            <div ng-switch-when="policy">
                                <ul class="unstyled break-all">
                                    <li ng-show="ruleData.policyConditions.filterBy">
                                        <b class="inline span4">Filter by:</b>
                                        <span class="span8">{{ruleData.policyConditions.filterBy}}</span>
                                    </li>
                                    <li ng-show="ruleData.policyConditions.filterBy && ruleData.policyConditions.filterBy!='all'">
                                        <b class="inline span4">{{ruleData.policyConditions.filterBy}}:</b>
                                        <span class="span8">{{ruleData.policyConditions.filterItemName}}</span>
                                    </li>
                                    <li ng-show="ruleData.promisehandle">
                                        <b class="inline span4">Promise handle:</b>
                                        <span class="span8">{{ruleData.policyConditions.promisehandle}}</span>
                                    </li>
                                    <li>
                                        <b class="inline span4">Status:</b>
                                        <span class="span8 upper-first">{{convertStatus(ruleData.policyConditions.promiseoutcome)}}</span>
                                    </li>
                                </ul>
                            </div>

                            <div ng-switch-when="softwareupdate">
                                 <ul class="unstyled break-all">
                                     <li>
                                        <b class="inline span4">Package name:</b>
                                        <div class="span8">
                                            <span ng-if="ruleData.softwareUpdateConditions.patchname!=''">{{ruleData.softwareUpdateConditions.patchname}}</span><span ng-if="!ruleData.softwareUpdateConditions.patchname">All</span>
                                        </div>
                                    </li>
                                     <li>
                                        <b class="inline span4">Architecture:</b>
                                        <div class="span8">
                                            <span ng-if="ruleData.softwareUpdateConditions.patcharchitecture!=''">{{ruleData.softwareUpdateConditions.patcharchitecture}}</span><span ng-if="!ruleData.softwareUpdateConditions.patcharchitecture">All</span>
                                        </div>
                                    </li>
                                </ul>

                            </div>

                            <span ng-switch-when="inventory">
                                 <ul class="unstyled break-all">
                                    <li ng-repeat="filter in alertData.rule.inventoryConditions.filters">
                                        <b class="inline span4">{{filter.label}}:</b>
                                         <span class="span8">
                                            {{filter.condition | FilterConditionLabel:filter}} <span ng-show="filter.type==='string'">'{{filter.value}}'</span><span ng-show="filter.type!=='string'">{{filter.value}}</span>
                                        </span>
                                    </li>
                                </ul>
                            </span>
                        </li>

                        <li>
                            <b class="inline span4">Severity:</b>
                            <span class="span8" ng-class="{'red':alertData.severity==='high'}" class="upper-first">{{alertData.severity}}</span>
                        </li>
                        <li>
                            <b class="inline span4">Widget:</b>
                            <span class="span8"><a ng-click="viewWidgetInfo(widgetData)">{{alertData.widgetName}}</a></span>
                        </li>
                        <li>
                            <b class="inline span4">Hosts:</b>
                            <span class="span8" ng-hide="alertData.hostContexts.name">All hosts</span>
                            <span class="span8" ng-show="alertData.hostContexts.name">{{alertData.hostContexts.name}}</span>
                        </li>
                        <li ng-show="alertData.lastStatusChange">
                            <b class="inline span4">Last status change:</b>
                            <span class="span8">{{alertData.lastStatusChange | convertTime}}</span>
                        </li>
                        <li ng-show="alertData.lastCheck">
                            <b class="inline span4">Time last run:</b>
                            <span class="span8">{{alertData.lastCheck | convertTime}}</span>
                        </li>
                        <li ng-show="alertData.paused==1">
                            <b class="inline span4">Alert paused</b>
                        </li>
                    </ul>

                </div>
            </div>

            <div>
                <h3>Event log</h3>
                 <ul class="unstyled" ng-show="alertEvents.length">
                    <li ng-repeat="event in alertEvents" class="margin-bottom-small">
                        <span>
                            {{event.message}}
                        </span>

                        <p class="muted" style="overflow:hidden;">
                            <span class="pull-left">{{event.time | convertTime}}</span>
                        </p>
                    </li>
                </ul>

                <a ng-click="loadNext('events')" ng-hide="loadLimit.events > alertEvents.length">
                    Load older events
                </a>

                <div ng-show="!alertEvents.length" class="muted margin-bottom">There have been no events for this alert</div>
            </div>
        </div>
    </div>

    <div style="clear:both"></div>
</div>